/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import potionstudios.byg.util.codec.CollectionCodec;

public class CodecUtil {
    public static final Codec<class_5321<class_1959>> BIOME_CODEC = class_2960.field_25139.comapFlatMap(resourceLocation -> DataResult.success((Object)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)resourceLocation)), class_5321::method_29177);
    public static final Codec<class_2248> BLOCK_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_2378.field_11146);
    public static final Codec<Integer> INTEGER_KEY_CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)Integer.valueOf(s)), Object::toString);
    public static final Codec<class_1792> ITEM_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_2378.field_11142);
    public static final Codec<class_1291> MOB_EFFECT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_2378.field_11159);
    public static final Codec<class_3852> VILLAGER_PROFESSION_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_2378.field_17167);
    public static final CollectionCodec<class_5321<class_1959>, Set<class_5321<class_1959>>> BIOME_SET_CODEC = new CollectionCodec<class_5321<class_1959>, Set>(BIOME_CODEC, ObjectOpenHashSet::new);

    public static Codec<Integer> intKeyRangeCodec(int min, int max) {
        Function check = Codec.checkRange((Number)min, (Number)max);
        return INTEGER_KEY_CODEC.flatXmap(check, check);
    }

    public static <T> Codec<T> createLoggedExceptionRegistryCodec(class_2378<T> registry) {
        return class_2960.field_25139.comapFlatMap(location -> {
            Optional result = registry.method_17966(location);
            if (result.isEmpty()) {
                StringBuilder registryElements = new StringBuilder();
                for (int i = 0; i < registry.method_29722().size(); ++i) {
                    Object object = registry.method_10200(i);
                    registryElements.append(i).append(". \"").append(registry.method_10221(object).toString()).append("\"\n");
                }
                return DataResult.error((String)String.format("\"%s\" is not a valid id in registry: %s.\nCurrent Registry Values:\n\n%s\n", location.toString(), registry.toString(), registryElements.toString()));
            }
            return DataResult.success(result.get());
        }, arg_0 -> registry.method_10221(arg_0));
    }

    public static <T> Codec<WrapForSerialization<T>> wrapCodecForCollectionSerializing(Codec<T> codec) {
        return RecordCodecBuilder.create(builder -> builder.group((App)codec.fieldOf("value").forGetter(tWrapForSerialization -> tWrapForSerialization.value)).apply((Applicative)builder, WrapForSerialization::new));
    }

    public static <T> WrapForSerialization<T> wrap(T toWrap) {
        return new WrapForSerialization<T>(toWrap);
    }

    public record WrapForSerialization<T>(T value) {
    }
}

